![[Pasted image 20250608180118.png]]

### **Overview of EAP Methods**

- **Two Types**:
    
    1. **Non-Tunnel EAP**: A simple architecture where a single EAP session exists between the supplicant and the authentication server.
    2. **Tunnel EAP**: Encapsulates an inner EAP method within an outer EAP to provide additional security.
- **Key Considerations**:
    
    - The choice of EAP method defines the authentication protocol and level of security.
    - Non-tunnel EAP methods expose the user identity in cleartext, while tunnel EAP methods offer secure, encrypted communication.

---

### **Non-Tunnel EAP Methods**

1. **EAP-MD5**:
    
    - **Authentication Protocol**: Challenge-response with hashing.
    - **Supported Credentials**: Passwords only.
    - **Limitations**:
        - No server authentication, making it vulnerable to man-in-the-middle attacks.
        - Use only if tunneled inside a secure EAP method (e.g., PEAP).
    - **Use Case**: Avoid unless absolutely necessary.
2. **EAP-MSCHAPv2**:
    
    - **Authentication Protocol**: Challenge-response with hashing.
    - **Supported Credentials**: Passwords or Microsoft password hashes.
    - **Advantages**:
        - Bidirectional authentication (client and server).
        - Suitable for integration with Microsoft Active Directory.
    - **Use Case**: When using plain passwords over untrusted channels.
3. **EAP-TLS**:
    
    - **Authentication Protocol**: Challenge-response with public key cryptography.
    - **Supported Credentials**: Digital certificates (public/private key pairs).
    - **Advantages**:
        - Strong security through PKI (Public Key Infrastructure).
        - Works with Active Directory or LDAP.
    - **Use Case**: When digital certificates are required for both client and server authentication.
4. **EAP-GTC**:
    
    - **Authentication Protocol**: Cleartext password or OTP transfer.
    - **Supported Credentials**: OTPs or passwords.
    - **Limitations**:
        - Vulnerable without tunneling (e.g., via PEAP or EAP-FAST).
    - **Use Case**: When OTPs are needed, must be tunneled for security.

---

### **Tunnel EAP Methods**

1. **EAP-FAST**:
    
    - **Authentication Protocol**: Challenge-response with symmetric cryptography (PAC).
    - **Supported Credentials**:
        - Server authentication using digital certificates.
        - PAC for mutual authentication.
        - Other credentials inside tunneled EAP methods.
    - **Advantages**:
        - EAP Chaining support (authentication of both user and device).
        - Suitable for Microsoft Windows endpoints in Active Directory.
    - **Use Case**: For identity protection and EAP Chaining.
2. **PEAP**:
    
    - **Authentication Protocol**: Challenge-response with public key cryptography.
    - **Supported Credentials**:
        - Server authentication using digital certificates.
        - Other credentials inside tunneled EAP methods.
    - **Advantages**:
        - Provides a secure TLS channel.
        - Commonly used to tunnel EAP-MSCHAPv2 or EAP-TLS.
    - **Use Case**: For securing inner EAP methods and verifying authentication servers.

---

### **Comparison of EAP Methods**

|**Method**|**Protocol**|**Supported Credentials**|**Use Case**|
|---|---|---|---|
|**EAP-MD5**|Challenge-response (hash)|Passwords|Avoid due to security vulnerabilities.|
|**EAP-MSCHAPv2**|Challenge-response (hash)|Passwords or Microsoft password hashes|Integration with Active Directory for plain password authentication.|
|**EAP-TLS**|Public key cryptography|Digital certificates|When PKI-based client and server authentication is required.|
|**EAP-GTC**|Cleartext password/OTP|OTPs or passwords|For OTPs; must be tunneled for security.|
|**EAP-FAST**|Symmetric cryptography|Certificates, PAC, credentials in inner EAP|For EAP Chaining or secure tunneling of inner methods.|
|**PEAP**|Public key cryptography|Certificates, credentials in inner EAP|For secure TLS channel and server certificate verification.|

---

### **Choosing the Right EAP Method**

1. **Non-Tunneled EAP**:
    
    - Use **EAP-TLS** when digital certificates are required.
    - Use **EAP-MSCHAPv2** for plain password authentication over untrusted channels.
2. **Tunneled EAP**:
    
    - Use **EAP-FAST** for identity protection and EAP Chaining.
    - Use **PEAP** for secure tunneling of EAP-MSCHAPv2 or EAP-TLS.

---

### **Key Takeaways**

- **Security Needs**: Use tunneled EAP methods to protect user identity and credentials.
- **Functionality**: Select the EAP method based on the type of credentials and security level required.
- **Common Deployments**:
    - **EAP-TLS** or **EAP-MSCHAPv2** tunneled inside **PEAP** or **EAP-FAST** are the most widely used methods for secure network access.
- **Special Requirements**:
    - Use **EAP-TLS** for digital certificate-based authentication.
    - Use **EAP-FAST** for scenarios requiring EAP Chaining.